//: annotations/UseCaseTracker.java
import java.lang.reflect.*;
import java.util.*;

public class UseCaseTracker {
  public static void
  trackUseCases(List<Integer> useCases, Class<?> cl) {
    for(Method m : cl.getDeclaredMethods()) {
      UseCase uc = m.getAnnotation(UseCase.class);
      if(uc != null) {
        System.out.println("Odnaleziony przypadek uycia:" + uc.id() +
          " " + uc.description());
        useCases.remove(new Integer(uc.id()));
      }
    }
    for(int i : useCases) {
      System.out.println("Ostrzeenie: brak przypadku uycia-" + i);
    }
  }
  public static void main(String[] args) {
    List<Integer> useCases = new ArrayList<Integer>();
    Collections.addAll(useCases, 47, 48, 49, 50);
    trackUseCases(useCases, PasswordUtils.class);
  }
} /* Output:
Odnaleziony przypadek uycia:47 Haso musi zawiera przynajmniej jedn cyfr
Odnaleziony przypadek uycia:48 brak opisu
Odnaleziony przypadek uycia:49 Nowe haso nie moe by identyczne z poprzednimi
Ostrzeenie: brak przypadku uycia-50
*///:~
