//: annotations/AtUnitExample4.java
package annotations;
import java.util.*;
import net.mindview.atunit.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class AtUnitExample4 {
  static String theory = "Wszystkie brontozaury " +
    "s szczupe na kocach i ZNACZNIE grubsze w rodku tuowia" +
    ", ktre zwa si znw ku pocztkowi.";
  private String word;
  private Random rand = new Random(); // Inicjowanie generatora odczytem czasu
  public AtUnitExample4(String word) { this.word = word; }
  public String getWord() { return word; }
  public String scrambleWord() {
    List<Character> chars = new ArrayList<Character>();
    for(Character c : word.toCharArray())
      chars.add(c);
    Collections.shuffle(chars, rand);
    StringBuilder result = new StringBuilder();
    for(char ch : chars)
      result.append(ch);
    return result.toString();
  }
  @TestProperty static List<String> input =
    Arrays.asList(theory.split(" "));
  @TestProperty
    static Iterator<String> words = input.iterator();
  @TestObjectCreate static AtUnitExample4 create() {
    if(words.hasNext())
      return new AtUnitExample4(words.next());
    else
      return null;
  }
  @Test boolean words() {
    print("'" + getWord() + "'");
    return getWord().equals("Wszystkie");
  }
  @Test boolean scramble1() {
    // Ustalanie generatora pod ktem powtarzalnoci wynikw:
    rand = new Random(47);
    print("'" + getWord() + "'");
    String scrambled = scrambleWord();
    print(scrambled);
    return scrambled.equals("oyarnzrbtou");
  }
  @Test boolean scramble2() {
    rand = new Random(74);
    print("'" + getWord() + "'");
    String scrambled = scrambleWord();
    print(scrambled);
    return scrambled.equals("s");
  }
  public static void main(String[] args) throws Exception {
    System.out.println("zaczynamy");
    OSExecute.command(
      "java net.mindview.atunit.AtUnit AtUnitExample4");
  }
} /* Output:
zaczynamy
annotations.AtUnitExample4
  . words 'Wszystkie'

  . scramble1 'brontozaury'
oyarnzrbtou

  . scramble2 's'
s

OK (3 test(y)(w))
*///:~
