//: access/Lunch.java
// Uywa specyfikator dostpu do klasy, czynic klas
// klas prywatn, z prywatnymi konstruktorami:

class Soup1 {
  private Soup1() {}
  // (1) Udostpnienie konstrukcji przy pomocy metody statycznej:
  public static Soup1 makeSoup() {
    return new Soup1();
  }
}

class Soup2 {
  private Soup2() {}
  // (2) Utworzenie obiektu statycznego i zwrcenie referencji
  // na danie (wzorzec projektowy "Singleton"):
  private static Soup2 ps1 = new Soup2();
  public static Soup2 access() {
    return ps1;
  }
  public void f() {}
}

// Tylko jedna klasa publiczna w pliku:
public class Lunch {
  void testPrivate() {
    // Nie wolno! Konstruktor prywatny:
    //! Soup1 soup = new Soup1();
  }
  void testStatic() {
    Soup1 soup = Soup1.makeSoup();
  }
  void testSingleton() {
    Soup2.access().f();
  }
} ///:~
