//: com:bruceeckel:simpletest:Test.java
// Proste narzdzie do testowania wynikw generowanych przez
// programy. Przechwytuje zawarto System.out, po czym 
// wywietla j na konsoli i zapisuje w buforze.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
package com.bruceeckel.simpletest;
import java.io.*;
import java.util.*;
import java.util.regex.*;

public class Test {
  // Przesunicie bitowe aby mona byo dodawa stae
  public static final int
    EXACT = 1 << 0, // Wiesze musz dokadnie sobie odpowiada
    AT_LEAST = 1 << 1, // Musz wystpowa co najmniej podane wiersze
    IGNORE_ORDER = 1 << 2, // Mona ignorowa kolejno wierdzy
    WAIT = 1 << 3; // Odczekaj a wszystkie wiersze zostan wygenerowane
  private String className;
  private TestStream testStream;
  public Test() {
    // Okrelenie nazwy klasy w ktrej obiekt
    // zosta utworzony:
    className =
      new Throwable().getStackTrace()[1].getClassName();
    testStream = new TestStream(className);
  }
  public static List fileToList(String fname) {
    ArrayList list = new ArrayList();
    try {
      BufferedReader in =
        new BufferedReader(new FileReader(fname));
      try {
        String line;
        while((line = in.readLine()) != null) {
          if(fname.endsWith(".txt"))
            list.add(line);
          else
            list.add(new TestExpression(line));
        }
      } finally {
        in.close();
      }
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
    return list;
  }
  public static List arrayToList(Object[] array) {
    List l = new ArrayList();
    for(int i = 0; i < array.length; i++) {
      if(array[i] instanceof TestExpression) {
        TestExpression re = (TestExpression)array[i];
        for(int j = 0; j < re.getNumber(); j++)
          l.add(re);
      } else {
        l.add(new TestExpression(array[i].toString()));
      }
    }
    return l;
  }
  public void expect(Object[] exp, int flags) {
    if((flags & WAIT) != 0)
      while(testStream.numOfLines < exp.length) {
        try {
          Thread.sleep(1000);
        } catch (InterruptedException e) {
          throw new RuntimeException(e);
        }
      }
      List output = fileToList(className + "Output.txt");
      if((flags & IGNORE_ORDER) == IGNORE_ORDER)
        OutputVerifier.verifyIgnoreOrder(output, exp);
      else if((flags & AT_LEAST) == AT_LEAST)
        OutputVerifier.verifyAtLeast(output,
          arrayToList(exp));
      else
        OutputVerifier.verify(output, arrayToList(exp));
    // Wyczyszczenie pliku wynikowego - patrz c06:Detergent.java
    testStream.openOutputFile();
  }
  public void expect(Object[] expected) {
    expect(expected, EXACT);
  }
  public void expect(Object[] expectFirst,
    String fname, int flags) {
    List expected = fileToList(fname);
    for(int i = 0; i < expectFirst.length; i++)
      expected.add(i, expectFirst[i]);
    expect(expected.toArray(), flags);
  }
  public void expect(Object[] expectFirst, String fname) {
    expect(expectFirst, fname, EXACT);
  }
  public void expect(String fname) {
    expect(new Object[] {}, fname, EXACT);
  }
} ///:~
