//: c15:JUnitDemo.java
// Prosty sposb wykorzystania JUnit w celu 
// przetestowania obiektu ArrayList
// {Koniczne: junit.jar}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;
import junit.framework.*;

// Abymy mogli mogli przekona si o tworzeniu obiektw
// list i ledzi informacje o ich niszczeniu
class CountedList extends ArrayList {
  private static int counter = 0;
  private int id = counter++;
  public CountedList() {
    System.out.println("CountedList #" + id);
  }
  public int getId() { return id; }
}

public class JUnitDemo extends TestCase {
  private static com.bruceeckel.simpletest.Test monitor =
    new com.bruceeckel.simpletest.Test();
  private CountedList list = new CountedList();
  // Zamiast setUp() mona take uy konstruktora:
  public JUnitDemo(String name) {
    super(name);
    for(int i = 0; i < 3; i++)
      list.add("" + i);
  }
  // Zatem metoda setUp() jest opcjonalna, lecz naley
  // j wykonywa bezporednio przed testem
  protected void setUp() {
    System.out.println("Przygotowywanie " + list.getId());
  }
  // tearDown() take jest opcjonalna, jest ona wywoywana 
  // po kadym tecie. setUp() i tearDown() mog by zarwno
  // chronione jak i publiczne:
  public void tearDown() {
    System.out.println("Niszczenie " + list.getId());
  }
  // Nazwy metod wszystkich testw rozpoczynaj si od "test":
  public void testInsert() {
    System.out.println("Wykonywanie testInsert()");
    assertEquals(list.size(), 3);
    list.add(1, "Insert");
    assertEquals(list.size(), 4);
    assertEquals(list.get(1), "Insert");
  }
  public void testReplace() {
    System.out.println("Wykonywanie testReplace()");
    assertEquals(list.size(), 3);
    list.set(1, "Replace");
    assertEquals(list.size(), 3);
    assertEquals(list.get(1), "Replace");
  }
  // Metoda "pomocnicza" redukujca powielanie kodu. Jeli
  // nazwa nie zaczyna si od "test", JUnit nie wykona metody
  // automatycznie.
  private void compare(ArrayList lst, String[] strs) {
    Object[] array = lst.toArray();
    assertTrue("Tablice nie s tej samej dugoci",
      array.length == strs.length);
    for(int i = 0; i < array.length; i++)
      assertEquals(strs[i], (String)array[i]);
  }
  public void testOrder() {
    System.out.println("Wykonywanie testOrder()");
    compare(list, new String[] { "0", "1", "2" });
  }
  public void testRemove() {
    System.out.println("Wykonywanie testRemove()");
    assertEquals(list.size(), 3);
    list.remove(1);
    assertEquals(list.size(), 2);
    compare(list, new String[] { "0", "2" });
  }
  public void testAddAll() {
    System.out.println("Wykonywanie testAddAll()");
    list.addAll(Arrays.asList(new Object[] {
      "Maa", "Afrykaska", "Jaskka"}));
    assertEquals(list.size(), 6);
    compare(list, new String[] { "0", "1", "2",
       "Maa", "Afrykaska", "Jaskka" });
  }
  public static void main(String[] args) {
    // Wywoujemy JUnit dla klasy
    junit.textui.TestRunner.run(JUnitDemo.class);
    monitor.expect(new String[] {
      "CountedList #0",
      "CountedList #1",
      "CountedList #2",
      "CountedList #3",
      "CountedList #4",
      // '.' oznacza pocztek kadego testu
      ".Przygotowywanie 0",
      "Wykonywanie testInsert()",
      "Niszczenie 0",
      ".Przygotowywanie 1",
      "Wykonywanie testReplace()",
      "Niszczenie 1",
      ".Przygotowywanie 2",
      "Wykonywanie testOrder()",
      "Niszczenie 2",
      ".Przygotowywanie 3",
      "Wykonywanie testRemove()",
      "Niszczenie 3",
      ".Przygotowywanie 4",
      "Wykonywanie testAddAll()",
      "Niszczenie 4",
      "",
      "%% Time: .*",
      "",
      "OK (5 tests)",
      "",
    });
  }
} ///:~
