//: c15:CustomHandler.java
// Jak tworzy wasne obiekty obsugi
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.logging.*;
import java.util.*;

public class CustomHandler {
  private static Test monitor = new Test();
  private static Logger logger =
    Logger.getLogger("CustomHandler");
  private static List strHolder = new ArrayList();
  public static void main(String[] args) {
    logger.addHandler(new Handler() {
      public void publish(LogRecord logRecord) {
        strHolder.add(logRecord.getLevel() + ":");
        strHolder.add(logRecord.getSourceClassName()+":");
        strHolder.add(logRecord.getSourceMethodName()+":");
        strHolder.add("<" + logRecord.getMessage() + ">");
        strHolder.add("\n");
      }
      public void flush() {}
      public void close() {}
    });
    logger.warning("Rejestracja ostrzeenia");
    logger.info("Rejestracja informacji");
    System.out.print(strHolder);
    monitor.expect(new String[] {
      "%% .* CustomHandler main",
      "WARNING: Rejestracja ostrzeenia",
      "%% .* CustomHandler main",
      "INFO: Rejestracja informacji",
      "[WARNING:, CustomHandler:, main:, " +
      "<Rejestracja ostrzeenia>, ",
      ", INFO:, CustomHandler:, main:, <Rejestracja informacji>, ",
      "]"
    });
  }
} ///:~
