//: c15:ConfigureLogging.java
// {Argumenty wywoania: -Djava.util.logging.config.file=log.prop}
// {Porzdki: java0.log,java0.log.lck}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.logging.*;

public class ConfigureLogging {
  private static Test monitor = new Test();
  static Logger lgr = Logger.getLogger("com"),
    lgr2 = Logger.getLogger("com.bruceeckel"),
    util = Logger.getLogger("com.bruceeckel.util"),
    test = Logger.getLogger("com.bruceeckel.test"),
    rand = Logger.getLogger("random");
  public ConfigureLogging() {
    /* W tym miejscu mona okrela dodatkowe obiekty 
       formatujce, obiekty obsugi oraz filtry. W pliku
       konfiguracyjnym mona okrela obiekty obsugi 
       wycznie dla rejestratora gwnego. */
  }
  public static void main(String[] args) {
    sendLogMessages(lgr);
    sendLogMessages(lgr2);
    sendLogMessages(util);
    sendLogMessages(test);
    sendLogMessages(rand);
    monitor.expect("ConfigureLogging.out");
  }
  private static void sendLogMessages(Logger logger) {
    System.out.println(" Nazwa rejestratora : "
      + logger.getName() + " Poziom: " + logger.getLevel());
    logger.finest("poziom 'Finest'");
    logger.finer("poziom 'Finer'");
    logger.fine("poziom 'Fine'");
    logger.config("poziom 'Config'");
    logger.info("poziom 'Info'");
    logger.warning("poziom 'Warning'");
    logger.severe("poziom 'Severe'");
  }
} ///:~
