//: c14:DynamicEvents.java
// Obsuga zdarze moe by zmieniana dynamicznie.
// Program pokazuje rwnie jednoczesne 
// wykonanie wielu akcji w jedyny zdarzeniu.
// <applet code=DynamicEvents
// width=250 height=400></applet>
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.bruceeckel.swing.*;

public class DynamicEvents extends JApplet {
  private java.util.List list = new ArrayList();
  private int i = 0;
  private JButton
    b1 = new JButton("Przycisk1"),
    b2 = new JButton("Przycisk2");
  private JTextArea txt = new JTextArea();
  class B implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      txt.append("Nacinito przycisk\n");
    }
  }
  class CountListener implements ActionListener {
    private int index;
    public CountListener(int i) { index = i; }
    public void actionPerformed(ActionEvent e) {
      txt.append("Odbiorca numer " + index + "\n");
    }
  }
  class B1 implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      txt.append("Nacinito przycisk 1\n");
      ActionListener a = new CountListener(i++);
      list.add(a);
      b2.addActionListener(a);
    }
  }
  class B2 implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      txt.append("Nacinito przycisk 2\n");
      int end = list.size() - 1;
      if(end >= 0) {
        b2.removeActionListener(
          (ActionListener)list.get(end));
        list.remove(end);
      }
    }
  }
  public void init() {
    Container cp = getContentPane();
    b1.addActionListener(new B());
    b1.addActionListener(new B1());
    b2.addActionListener(new B());
    b2.addActionListener(new B2());
    JPanel p = new JPanel();
    p.add(b1);
    p.add(b2);
    cp.add(BorderLayout.NORTH, p);
    cp.add(new JScrollPane(txt));
  }
  public static void main(String[] args) {
    Console.run(new DynamicEvents(), 250, 400);
  }
} ///:~