//: c13:SynchronizedEvenGenerator.java
// Wykorzystanie "synchronized" w celu zapobieenia 
// kolizjom wtkw.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.

public
class SynchronizedEvenGenerator implements Invariant {
  private int i;
  public synchronized void next() { i++; i++; }
  public synchronized int getValue() { return i; }
  // Niesynchronizowana aby mona j byo wywoywa
  // w dowolnym momencie i aby stanowia doskonay test
  public InvariantState invariant() {
    int val = getValue();
    if(val % 2 == 0)
      return new InvariantOK();
    else
      return new InvariantFailure(new Integer(val));
  }
  public static void main(String[] args) {
    SynchronizedEvenGenerator gen =
      new SynchronizedEvenGenerator();
    new InvariantWatcher(gen, 4000); // czas oczekiwania 4 sek.
    while(true)
      gen.next();
  }
} ///:~
