//: c13:Stopping.java
// Bezpieczny sposb zatrzymywania wtku.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;

class CanStop extends Thread {
  // Musi by volatile:
  private volatile boolean stop = false;
  private int counter = 0;
  public void run() {
    while(!stop && counter < 10000) {
      System.out.println(counter++);
    }
    if(stop)
      System.out.println("Wykryto danie zatrzymania");
  }
  public void requestStop() { stop = true; }
}

public class Stopping {
  public static void main(String[] args) {
    final CanStop stoppable = new CanStop();
    stoppable.start();
    new Timer(true).schedule(new TimerTask() {
      public void run() {
        System.out.println("Prosimy o zatrzymanie");
        stoppable.requestStop();
      }
    }, 500); // wywoanie run() po 500 milisekundach
  }
} ///:~
