//: c13:DiningPhilosophers.java
// Pokazuje jak w programie moe by ukryte 
// prawdopodobiestwo wystpienia wzajemnej blokady.
// {Args: 5 0 deadlock 4}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;

class Chopstick {
  private static int counter = 0;
  private int number = counter++;
  public String toString() {
    return "Paeczka " + number;
  }
}

class Philosopher extends Thread {
  private static Random rand = new Random();
  private static int counter = 0;
  private int number = counter++;
  private Chopstick leftChopstick;
  private Chopstick rightChopstick;
  static int ponder = 0; // Dostp w ramach pakietu
  public Philosopher(Chopstick left, Chopstick right) {
    leftChopstick = left;
    rightChopstick = right;
    start();
  }
  public void think() {
    System.out.println(this + " rozmyla");
    if(ponder > 0)
      try {
        sleep(rand.nextInt(ponder));
      } catch(InterruptedException e) {
        throw new RuntimeException(e);
      }
  }
  public void eat() {
    synchronized(leftChopstick) {
      System.out.println(this + " ma "
        + this.leftChopstick + " czeka na "
        + this.rightChopstick);
      synchronized(rightChopstick) {
        System.out.println(this + " spoywa posiek");
      }
    }
  }
  public String toString() {
    return "Filozof " + number;
  }
  public void run() {
    while(true) {
      think();
      eat();
    }
  }
}

public class DiningPhilosophers {
  public static void main(String[] args) {
    if(args.length < 3) {
      System.err.println("Sposb uycia:\n" +
        "java DiningPhilosophers iloFilozofw " +
        "wspczynnikRozmyla impas limitCzasu\n" +
        "Uycie argumentu wspczynnikRozmyla rnego od zera " +
        "spowoduje stosowanie losowego czasu upienia w think().\n" +
        "Jeli argument impas nie jest acuchem " +
        "'impas', wzajemna blokada nie bdzie wystpowa.\n" +
        "Warto argumentu limitCzasu rna od zera sprawie, " +
        "e program zakoczy si po upyniciu podanej iloci sekund.");
      System.exit(1);
    }
    Philosopher[] philosopher =
      new Philosopher[Integer.parseInt(args[0])];
    Philosopher.ponder = Integer.parseInt(args[1]);
    Chopstick
      left = new Chopstick(),
      right = new Chopstick(),
      first = left;
    int i = 0;
    while(i < philosopher.length - 1) {
      philosopher[i++] =
        new Philosopher(left, right);
      left = right;
      right = new Chopstick();
    }
    if(args[2].equals("impas"))
      philosopher[i] = new Philosopher(left, first);
    else // Zamiana wartoci uniemoliwia wystpowanie wzajemnej blokady:
      philosopher[i] = new Philosopher(first, left);
    // Opcjonalne zakoczenie programu:
    if(args.length >= 4) {
      int delay = Integer.parseInt(args[3]);
      if(delay != 0)
        new Timeout(delay * 1000, "Czas min.");
    }
  }
} ///:~
