//: c13:CriticalSection.java
// Synchronizacja bloku kodu a nie caej metody. 
// Przedstawia take zabezpieczanie niebezpiecznej klasy przez klas,
// ktra poprawnie dziaa w rozwizaniach wielowtkowych.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;

class Pair { // Niebezpieczna
  private int x, y;
  public Pair(int x, int y) {
    this.x = x;
    this.y = y;
  }
  public Pair() { this(0, 0); }
  public int getX() { return x; }
  public int getY() { return y; }
  public void incrementX() { x++; }
  public void incrementY() { y++; }
  public String toString() {
    return "x: " + x + ", y: " + y;
  }
  public class PairValuesNotEqualException
  extends RuntimeException {
    public PairValuesNotEqualException() {
      super("Wartoci pary nie s sobie rwne: " + Pair.this);
    }
  }
  // Zaburzony niezmiennik -- obie zmienne musz by sobie rwne:
  public void checkState() {
    if(x != y)
      throw new PairValuesNotEqualException();
  }
}

// Ochrona klasy Pair wewntrz klasy zachowujcej si 
// poprawnie w rodowiskach wielowtkowych:
abstract class PairManager {
  protected Pair p = new Pair();
  private List storage = new ArrayList();
  public synchronized Pair getPair() {
    // Utworzenie kopii aby orygina by bezpieczny:
    return new Pair(p.getX(), p.getY());
  }
  protected void store() { storage.add(getPair()); }
  // Metoda szablon:
  public abstract void doTask();
}

// Synchronizacja caej metody:
class PairManager1 extends PairManager {
  public synchronized void doTask() {
    p.incrementX();
    p.incrementY();
    store();
  }
}

// Wykorzystanie sekcji krytycznych:
class PairManager2 extends PairManager {
  public void doTask() {
    synchronized(this) {
      p.incrementX();
      p.incrementY();
    }
    store();
  }
}

class PairManipulator extends Thread {
  private PairManager pm;
  private int checkCounter = 0;
  private class PairChecker extends Thread {
    PairChecker() { start(); }
    public void run() {
      while(true) {
        checkCounter++;
        pm.getPair().checkState();
      }
    }
  }
  public PairManipulator(PairManager pm) {
    this.pm = pm;
    start();
    new PairChecker();
  }
  public void run() {
    while(true) {
      pm.doTask();
    }
  }
  public String toString() {
    return "Para: " + pm.getPair() +
      " checkCounter = " + checkCounter;
  }
}

public class CriticalSection {
  public static void main(String[] args) {
    // Przetestowanie dwch rnych rozwiza:
    final PairManipulator
      pm1 = new PairManipulator(new PairManager1()),
      pm2 = new PairManipulator(new PairManager2());
    new Timer(true).schedule(new TimerTask() {
      public void run() {
        System.out.println("pm1: " + pm1);
        System.out.println("pm2: " + pm2);
        System.exit(0);
      }
    }, 500); // wywoanie run() po 500 millisekundach
  }
} ///:~
