//: c12:StartEnd.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.regex.*;
import com.bruceeckel.simpletest.*;

public class StartEnd {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    String[] input = new String[] {
      "Java prezentuje wyraenia regularne w JDK 1.4",
      "wyraenia regularne ju s w jzyku Java",
      "Java rezygnuje z przereklamowanych wyrae"
    };
    Pattern
      p1 = Pattern.compile("re\\w*"),
      p2 = Pattern.compile("Java.*");
    for(int i = 0; i < input.length; i++) {
      System.out.println("Wejcie: " + i + ": " + input[i]);
      Matcher
        m1 = p1.matcher(input[i]),
        m2 = p2.matcher(input[i]);
      while(m1.find())
        System.out.println("m1.find() '" + m1.group() +
          "' start = "+ m1.start() + " end = " + m1.end());
      while(m2.find())
        System.out.println("m2.find() '" + m2.group() +
          "' start = "+ m2.start() + " end = " + m2.end());
      if(m1.lookingAt()) // Wywoanie reset() niepotrzebne
        System.out.println("m1.lookingAt() start = "
          + m1.start() + " end = " + m1.end());
      if(m2.lookingAt())
        System.out.println("m2.lookingAt() start = "
          + m2.start() + " end = " + m2.end());
      if(m1.matches()) // Wywoanie reset() niepotrzebne
        System.out.println("m1.matches() start = "
          + m1.start() + " end = " + m1.end());
      if(m2.matches())
        System.out.println("m2.matches() start = "
          + m2.start() + " end = " + m2.end());
    }
    monitor.expect(new String[] {
      "Wejcie: 0: Java prezentuje wyraenia regularne w JDK 1.4",
      "m1.find() 'rezentuje' start = 6 end = 15",
      "m1.find() 'regularne' start = 26 end = 35",
      "m2.find() 'Java prezentuje wyraenia regularne w JDK 1.4' " +
      "start = 0 end = 45",
      "m2.lookingAt() start = 0 end = 45",
      "m2.matches() start = 0 end = 45",
      "Wejcie: 1: wyraenia regularne ju s w jzyku Java",
      "m1.find() 'regularne' start = 10 end = 19",
      "m2.find() 'Java' start = 36 end = 40",
      "Wejcie: 2: Java rezygnuje z przereklamowanych wyrae",
      "m1.find() 'rezygnuje' start = 5 end = 14",
      "m1.find() 'reklamowanych' start = 21 end = 34",
      "m2.find() 'Java rezygnuje z przereklamowanych wyrae' " + 
      "start = 0 end = 42",
      "m2.lookingAt() start = 0 end = 42",
      "m2.matches() start = 0 end = 42"
    });
  }
} ///:~