//: c12:MakeDirectories.java
// Demonstracja uycia klasy File w celu 
// tworzenia katalogw i manipulacji na plikach
// {Argumenty: MakeDirectoriesTest}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;

public class MakeDirectories {
  private static Test monitor = new Test();
  private static void usage() {
    System.err.println(
    "Uycie: MakeDirectories sciezka1 ...\n" +
    "Tworzy wszystkie scieki\n" +
    "Uycie: MakeDirectories -d sciezka1 ...\n" +
    "Usuwa wszystkie scieki\n" +
    "Uycie: MakeDirectories -r sciezka1 sciezka2\n" +
    "Zmienia nazw scieka1 na scieka2\n");
    System.exit(1);
  }
  private static void fileData(File f) {
    System.out.println(
      "cieka absolutna: " + f.getAbsolutePath() +
      "\n Moliwo odczytu: " + f.canRead() +
      "\n Moliwo zapisu: " + f.canWrite() +
      "\n Nazwa: " + f.getName() +
      "\n Nadrzdna: " + f.getParent() +
      "\n cieka: " + f.getPath() +
      "\n Dugo: " + f.length() +
      "\n Ostatnia modyfikacja: " + f.lastModified());
    if(f.isFile())
      System.out.println("plik");
    else if(f.isDirectory())
      System.out.println("katalog");
  }
  public static void main(String[] args) {
    if(args.length < 1) usage();
    if(args[0].equals("-r")) {
      if(args.length != 3) usage();
      File
        old = new File(args[1]),
        rname = new File(args[2]);
      old.renameTo(rname);
      fileData(old);
      fileData(rname);
      return; // Wyjcie z metody main
    }
    int count = 0;
    boolean del = false;
    if(args[0].equals("-d")) {
      count++;
      del = true;
    }
    count--;
    while(++count < args.length) {
      File f = new File(args[count]);
      if(f.exists()) {
        System.out.println(f + " istnieje");
        if(del) {
          System.out.println("usuwanie..." + f);
          f.delete();
        }
      }
      else { // nie istnieje
        if(!del) {
          f.mkdirs();
          System.out.println("utworzono " + f);
        }
      }
      fileData(f);
    }
    if(args.length == 1 &&
        args[0].equals("MakeDirectoriesTest"))
      monitor.expect(new String[] {
        "%% (MakeDirectoriesTest istnieje"+
          "|utworzono MakeDirectoriesTest)",
        "%% cieka absolutna: "
          + "\\S+MakeDirectoriesTest",
        "%%  Moliwo odczytu: (true|false)",
        "%%  Moliwo zapisu: (true|false)",
        " Nazwa: MakeDirectoriesTest",
        " Nadrzdna: null",
        " cieka: MakeDirectoriesTest",
        "%%  Dugo: \\d+",
        "%%  Ostatnia modyfikacja: \\d+",
        "katalog"
      });
  }
} ///:~
