//: c12:LockingMappedFiles.java
// Blokowanie dostpu do fragmentw 
// pliku odwzorowywanego w pamici.
// {Naley uruchamia tcznie}
// {Porzdki: test.dat}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.io.*;
import java.nio.*;
import java.nio.channels.*;

public class LockingMappedFiles {
  static final int LENGTH = 0x8FFFFFF; // 128 Mb
  static FileChannel fc;
  public static void main(String[] args) throws Exception {
    fc = 
      new RandomAccessFile("test.dat", "rw").getChannel();
    MappedByteBuffer out = 
      fc.map(FileChannel.MapMode.READ_WRITE, 0, LENGTH);
    for(int i = 0; i < LENGTH; i++)
      out.put((byte)'x');
    new LockAndModify(out, 0, 0 + LENGTH/3);
    new LockAndModify(out, LENGTH/2, LENGTH/2 + LENGTH/4);
  }
  private static class LockAndModify extends Thread {
    private ByteBuffer buff;
    private int start, end;
    LockAndModify(ByteBuffer mbb, int start, int end) {
      this.start = start;
      this.end = end;
      mbb.limit(end);
      mbb.position(start);
      buff = mbb.slice();
      start();
    }    
    public void run() {
      try {
        // Wyczne zablokowanie obszarw, ktre 
        // nie pokrywaj si
        FileLock fl = fc.lock(start, end, false);
        System.out.println("Blokada: "+ start +" do "+ end);
        // Wprowadzenie modyfikacji:
        while(buff.position() < buff.limit() - 1)
          buff.put((byte)(buff.get() + 1));
        fl.release();
        System.out.println("Zwolniona blokada: "+start+" do "+ end);
      } catch(IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
} ///:~