//: c12:GetData.java
// Pobieranie rnych danych z obiektu ByteBuffer
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.nio.*;
import com.bruceeckel.simpletest.*;

public class GetData {
  private static Test monitor = new Test();
  private static final int BSIZE = 1024;
  public static void main(String[] args) {
    ByteBuffer bb = ByteBuffer.allocate(BSIZE);
    // Podczas alokacji zawarto bufora jest zerowana:
    int i = 0;
    while(i++ < bb.limit())
      if(bb.get() != 0)
        System.out.println("rne od zera");
    System.out.println("i = " + i);
    bb.rewind();
    // Zapis i odczyt tablicy znakw:
    bb.asCharBuffer().put("Witam!");
    char c;
    while((c = bb.getChar()) != 0)
      System.out.print(c + " ");
    System.out.println();
    bb.rewind();
    // Zapis i odczyt wartoci typu short:
    bb.asShortBuffer().put((short)471142);
    System.out.println(bb.getShort());
    bb.rewind();
    // Zapis i odczyt wartoci typu int:
    bb.asIntBuffer().put(99471142);
    System.out.println(bb.getInt());
    bb.rewind();
    // Zapis i odczyt wartoci typu long:
    bb.asLongBuffer().put(99471142);
    System.out.println(bb.getLong());
    bb.rewind();
    // Zapis i odczyt wartoci typu float:
    bb.asFloatBuffer().put(99471142);
    System.out.println(bb.getFloat());
    bb.rewind();
    // Zapis i odczyt wartoci typu double:
    bb.asDoubleBuffer().put(99471142);
    System.out.println(bb.getDouble());
    bb.rewind();
    monitor.expect(new String[] {
      "i = 1025",
      "W i t a m ! ",
      "12390", // Przycicie zmienia warto
      "99471142",
      "99471142",
      "9.9471144E7",
      "9.9471142E7"
    });
  }
} ///:~