//: c12:GetChannel.java
// Tworzenie kanaw na bazie strumieni
// {Porzdki: data.txt}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.io.*;
import java.nio.*;
import java.nio.channels.*;

public class GetChannel {
  private static final int BSIZE = 1024;
  public static void main(String[] args) throws Exception {
    // Zapis do pliku:
    FileChannel fc =
      new FileOutputStream("data.txt").getChannel();
    fc.write(ByteBuffer.wrap("Jaki tekst. ".getBytes()));
    fc.close();
    // Dopisanie danych na kocu pliku:
    fc =
      new RandomAccessFile("data.txt", "rw").getChannel();
    fc.position(fc.size()); // Przejcie na koniec
    fc.write(ByteBuffer.wrap("Dalsza cz tekstu.".getBytes()));
    fc.close();
    // Odczyt pliku:
    fc = new FileInputStream("data.txt").getChannel();
    ByteBuffer buff = ByteBuffer.allocate(BSIZE);
    fc.read(buff);
    buff.flip();
    while(buff.hasRemaining())
      System.out.print((char)buff.get());    
  }
} ///:~