//: c11:Utilities.java
// Prosta demonstracja narzdzi klasy Collections.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;
import com.bruceeckel.util.*;

public class Utilities {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    List list = Arrays.asList(
      "jeden Dwa trzy Cztery pi sze jeden".split(" "));
    System.out.println(list);
    System.out.println("max: " + Collections.max(list));
    System.out.println("min: " + Collections.min(list));
    AlphabeticComparator comp = new AlphabeticComparator();
    System.out.println("max z comparator-em: " +
      Collections.max(list, comp));
    System.out.println("min z comparator-em: " +
      Collections.min(list, comp));
    List sublist =
      Arrays.asList("Cztery pi sze".split(" "));
    System.out.println("indexOfSubList: " +
      Collections.indexOfSubList(list, sublist));
    System.out.println("lastIndexOfSubList: " +
      Collections.lastIndexOfSubList(list, sublist));
    Collections.replaceAll(list, "jeden", "Yo");
    System.out.println("zastpienie wszystkich: " + list);
    Collections.reverse(list);
    System.out.println("w odwrotnej kolejnoci: " + list);
    Collections.rotate(list, 3);
    System.out.println("obrt: " + list);
    List source =
      Arrays.asList("w macierzy".split(" "));
    Collections.copy(list, source);
    System.out.println("kopiowanie: " + list);
    Collections.swap(list, 0, list.size() - 1);
    System.out.println("zamiana: " + list);
    Collections.fill(list, "pop");
    System.out.println("wypenienie: " + list);
    List dups = Collections.nCopies(3, "pstryk");
    System.out.println("powtrzenie: " + dups);
    // Pobranie enumeratora (Enumeration):
    Enumeration e = Collections.enumeration(dups);
    Vector v = new Vector();
    while(e.hasMoreElements())
      v.addElement(e.nextElement());
    // Konwersja obiektu Vector
    // do List przy uyciu enumeratora (Enumeration):
    ArrayList arrayList = Collections.list(v.elements());
    System.out.println("arrayList: " + arrayList);
    monitor.expect(new String[] {
      "[jeden, Dwa, trzy, Cztery, pi, sze, jeden]",
      "max: trzy",
      "min: Cztery",
      "max z comparator-em: trzy",
      "min z comparator-em: Cztery",
      "indexOfSubList: 3",
      "lastIndexOfSubList: 3",
      "zastpienie wszystkich: [Yo, Dwa, trzy, Cztery, pi, sze, Yo]",
      "w odwrotnej kolejnoci: [Yo, sze, pi, Cztery, trzy, Dwa, Yo]",
      "obrt: [trzy, Dwa, Yo, Yo, sze, pi, Cztery]",
      "kopiowanie: [w, macierzy, Yo, Yo, sze, pi, Cztery]",
      "zamiana: [Cztery, macierzy, Yo, Yo, sze, pi, w]",
      "wypenienie: [pop, pop, pop, pop, pop, pop, pop]",
      "powtrzenie: [pstryk, pstryk, pstryk]",
      "arrayList: [pstryk, pstryk, pstryk]"
    });
  }
} ///:~