//: c11:Stacks.java
// Prezentacja klasy Stack.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;
import c08.Month;

public class Stacks {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    Stack stack = new Stack();
    for(int i = 0; i < Month.month.length; i++)
      stack.push(Month.month[i] + " ");
    System.out.println("Stos = " + stack);
    // Wykorzytanie stosu jako wektora (Vector):
    stack.addElement("Ostatni wiersz");
    System.out.println("element 5 = " +
      stack.elementAt(5));
    System.out.println("Pobieranie elementw:");
    while(!stack.empty())
      System.out.println(stack.pop());
    monitor.expect(new String[] {
      "Stos = [Stycze , Luty , Marzec , Kwiecie , Maj "+
        ", Czerwiec , Lipiec , Sierpie , Wrzesie , Padziernik , " +
        "Listopad , Grudzie ]",
      "element 5 = Czerwiec ",
      "Pobieranie elementw:",
      "Ostatni wiersz",
      "Grudzie ",
      "Listopad ",
      "Padziernik ",
      "Wrzesie ",
      "Sierpie ",
      "Lipiec ",
      "Czerwiec ",
      "Maj ",
      "Kwiecie ",
      "Marzec ",
      "Luty ",
      "Stycze "
    });
  }
} ///:~
