//: c11:SortedMapDemo.java
// Co mona zrobi z obiektem klasy TreeMap.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import com.bruceeckel.util.*;
import java.util.*;

public class SortedMapDemo {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    TreeMap sortedMap = new TreeMap();
    Collections2.fill(
      sortedMap, SimplePairGenerator.gen, 10);
    System.out.println(sortedMap);
    Object
      low = sortedMap.firstKey(),
      high = sortedMap.lastKey();
    System.out.println(low);
    System.out.println(high);
    Iterator it = sortedMap.keySet().iterator();
    for(int i = 0; i <= 6; i++) {
      if(i == 3) low = it.next();
      if(i == 6) high = it.next();
      else it.next();
    }
    System.out.println(low);
    System.out.println(high);
    System.out.println(sortedMap.subMap(low, high));
    System.out.println(sortedMap.headMap(high));
    System.out.println(sortedMap.tailMap(low));
    monitor.expect(new String[] {
      "{cztery=D, dwa=B, dziesi=J, dziewi=I, jeden=A, osiem=H," +
      " pi=E, siedem=G, sze=F, trzy=C}",
      "cztery",
      "trzy",
      "dziewi",
      "siedem",
      "{dziewi=I, jeden=A, osiem=H, pi=E}",
      "{cztery=D, dwa=B, dziesi=J, dziewi=I, " +
      "jeden=A, osiem=H, pi=E}",
      "{dziewi=I, jeden=A, osiem=H, pi=E, " +
      "siedem=G, sze=F, trzy=C}"
    });
  }
} ///:~
