//: c11:LinkedHashMapDemo.java
// Co mona zrobi z obiektem LinkedHashMap.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import com.bruceeckel.util.*;
import java.util.*;

public class LinkedHashMapDemo {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    LinkedHashMap linkedMap = new LinkedHashMap();
    Collections2.fill(
      linkedMap, SimplePairGenerator.gen, 10);
    System.out.println(linkedMap);
    // W kolejnoci: ostatnio uywany
    linkedMap = new LinkedHashMap(16, 0.75f, true);
    Collections2.fill(
      linkedMap, SimplePairGenerator.gen, 10);
    System.out.println(linkedMap);
    for(int i = 0; i < 7; i++) // Dostp:
      linkedMap.get(SimplePairGenerator.gen.items[i].key);
    System.out.println(linkedMap);
    linkedMap.get(SimplePairGenerator.gen.items[0].key);
    System.out.println(linkedMap);
    monitor.expect(new String[] {
      "{jeden=A, dwa=B, trzy=C, cztery=D, pi=E, " +
       "sze=F, siedem=G, osiem=H, dziewi=I, dziesi=J}",
      "{jeden=A, dwa=B, trzy=C, cztery=D, pi=E, " +
       "sze=F, siedem=G, osiem=H, dziewi=I, dziesi=J}",
      "{osiem=H, dziewi=I, dziesi=J, jeden=A, dwa=B, " +
       "trzy=C, cztery=D, pi=E, sze=F, siedem=G}",
      "{osiem=H, dziewi=I, dziesi=J, dwa=B, trzy=C, " +
       "cztery=D, pi=E, sze=F, siedem=G, jeden=A}"
    });
  }
} ///:~
