//: c11:CountedString.java
// Poprawna implementacja metody hashCode().
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;

public class CountedString {
  private static Test monitor = new Test();
  private static List created = new ArrayList();
  private String s;
  private int id = 0;
  public CountedString(String str) {
    s = str;
    created.add(s);
    Iterator it = created.iterator();
    // Id jest cakowit liczb egzemplarzy tego
    // acucha tekstowego uywanych przez CountedString:
    while(it.hasNext())
      if(it.next().equals(s))
        id++;
  }
  public String toString() {
    return "String: " + s + " id: " + id +
      " hashCode(): " + hashCode();
  }
  public int hashCode() {
    // Bardzo proste rozwizanie:
    // return s.hashCode() * id;
    // Wykorzystuje metod Joshuy Blocha:
    int result = 17;
    result = 37*result + s.hashCode();
    result = 37*result + id;
    return result;
  }
  public boolean equals(Object o) {
    return (o instanceof CountedString)
      && s.equals(((CountedString)o).s)
      && id == ((CountedString)o).id;
  }
  public static void main(String[] args) {
    Map map = new HashMap();
    CountedString[] cs = new CountedString[10];
    for(int i = 0; i < cs.length; i++) {
      cs[i] = new CountedString("Cze");
      map.put(cs[i], new Integer(i));
    }
    System.out.println(map);
    for(int i = 0; i < cs.length; i++) {
      System.out.println("Szukane - " + cs[i]);
      System.out.println(map.get(cs[i])); //
    }
    monitor.expect(new String[] {
      "{String: Cze id: 9 hashCode(): -1867059884=8," +
      " String: Cze id: 4 hashCode(): -1867059889=3," +
      " String: Cze id: 2 hashCode(): -1867059891=1," +
      " String: Cze id: 1 hashCode(): -1867059892=0," +
      " String: Cze id: 7 hashCode(): -1867059886=6," +
      " String: Cze id: 10 hashCode(): -1867059883=9," +
      " String: Cze id: 5 hashCode(): -1867059888=4," +
      " String: Cze id: 3 hashCode(): -1867059890=2," +
      " String: Cze id: 6 hashCode(): -1867059887=5," +
      " String: Cze id: 8 hashCode(): -1867059885=7}",
      "Szukane - String: Cze id: 1 hashCode(): -1867059892",
      "0",
      "Szukane - String: Cze id: 2 hashCode(): -1867059891",
      "1",
      "Szukane - String: Cze id: 3 hashCode(): -1867059890",
      "2",
      "Szukane - String: Cze id: 4 hashCode(): -1867059889",
      "3",
      "Szukane - String: Cze id: 5 hashCode(): -1867059888",
      "4",
      "Szukane - String: Cze id: 6 hashCode(): -1867059887",
      "5",
      "Szukane - String: Cze id: 7 hashCode(): -1867059886",
      "6",
      "Szukane - String: Cze id: 8 hashCode(): -1867059885",
      "7",
      "Szukane - String: Cze id: 9 hashCode(): -1867059884",
      "8",
      "Szukane - String: Cze id: 10 hashCode(): -1867059883",
      "9"
    });
  }
} ///:~
