//: c11:ArraySize.java
// Inicjalizacja i zmiana odwoa do tablic.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Weeble {} // Mae mityczne stworzenie

public class ArraySize {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    // Tablice obiektw:
    Weeble[] a; // Niezainicjalizowana zmienna lokalna
    Weeble[] b = new Weeble[5]; // Puste referencje
    Weeble[] c = new Weeble[4];
    for(int i = 0; i < c.length; i++)
      if(c[i] == null) // Mona sprawdza puste referencje
        c[i] = new Weeble();
    // Inicjalizacja grupowa:
    Weeble[] d = {
      new Weeble(), new Weeble(), new Weeble()
    };
    // Dynamiczna inicjalizacja grupowa:
    a = new Weeble[] {
      new Weeble(), new Weeble()
    };
    System.out.println("a.length=" + a.length);
    System.out.println("b.length = " + b.length);
    // Odwoania wewntrz tablicy s 
    // automatycznie inicjalizowane wartoci null:
    for(int i = 0; i < b.length; i++)
      System.out.println("b[" + i + "]=" + b[i]);
    System.out.println("c.length = " + c.length);
    System.out.println("d.length = " + d.length);
    a = d;
    System.out.println("a.length = " + a.length);

    // Tablice typw podstawowych:
    int[] e; // Odwoanie puste
    int[] f = new int[5];
    int[] g = new int[4];
    for(int i = 0; i < g.length; i++)
      g[i] = i*i;
    int[] h = { 11, 47, 93 };
    // Bd kompilacji: zmienna e nie zainicjalizowana:
    //!System.out.println("e.length=" + e.length);
    System.out.println("f.length = " + f.length);
    // Zmienne typu podstawowego wewntrz tablicy
    // s automatycznie inicjalizowane wartoci zero:
    for(int i = 0; i < f.length; i++)
      System.out.println("f[" + i + "]=" + f[i]);
    System.out.println("g.length = " + g.length);
    System.out.println("h.length = " + h.length);
    e = h;
    System.out.println("e.length = " + e.length);
    e = new int[] { 1, 2 };
    System.out.println("e.length = " + e.length);
    monitor.expect(new String[] {
      "a.length=2",
      "b.length = 5",
      "b[0]=null",
      "b[1]=null",
      "b[2]=null",
      "b[3]=null",
      "b[4]=null",
      "c.length = 4",
      "d.length = 3",
      "a.length = 3",
      "f.length = 5",
      "f[0]=0",
      "f[1]=0",
      "f[2]=0",
      "f[3]=0",
      "f[4]=0",
      "g.length = 4",
      "h.length = 3",
      "e.length = 3",
      "e.length = 2"
    });
  }
} ///:~
