//: c10:SweetShop.java
// Sprawdzenie sposobu dziaania adowania klas.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Candy {
  static {
    System.out.println("adowanie klasy Candy");
  }
}

class Gum {
  static {
    System.out.println("adowanie klasy Gum");
  }
}

class Cookie {
  static {
    System.out.println("adowanie klasy Cookie");
  }
}

public class SweetShop {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    System.out.println("wewntrz metody main()");
    new Candy();
    System.out.println("Po utworzeniu obiektu Candy");
    try {
      Class.forName("Gum");
    } catch(ClassNotFoundException e) {
      System.out.println("Nie mona znale Gum");
    }
    System.out.println("Po wywoaniu metody Class.forName(\"Gum\")");
    new Cookie();
    System.out.println("Po utworzeniu obiektu Cookie");
    monitor.expect(new String[] {
      "wewntrz metody main()",
      "adowanie klasy Candy",
      "Po utworzeniu obiektu Candy",
      "adowanie klasy Gum",
      "Po wywoaniu metody Class.forName(\"Gum\")",
      "adowanie klasy Cookie",
      "Po utworzeniu obiektu Cookie"
    });
  }
} ///:~
