//: c10:AssociativeArray.java
// Kojarzy klucze z wartociami.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
package c10;
import com.bruceeckel.simpletest.*;

public class AssociativeArray {
  private static Test monitor = new Test();
  private Object[][] pairs;
  private int index;
  public AssociativeArray(int length) {
    pairs = new Object[length][2];
  }
  public void put(Object key, Object value) {
    if(index >= pairs.length)
      throw new ArrayIndexOutOfBoundsException();
    pairs[index++] = new Object[] { key, value };
  }
  public Object get(Object key) {
    for(int i = 0; i < index; i++)
      if(key.equals(pairs[i][0]))
        return pairs[i][1];
    throw new RuntimeException("Nie udao si odnale klucza");
  }
  public String toString() {
    String result = "";
    for(int i = 0; i < index; i++) {
      result += pairs[i][0] + " : " + pairs[i][1];
      if(i < index - 1) result += "\n";
    }
    return result;
  }
  public static void main(String[] args) {
    AssociativeArray map = new AssociativeArray(6);
    map.put("niebo", "niebieskie");
    map.put("trawa", "zielona");
    map.put("ocean", "niespokojny");
    map.put("drzewo", "wysokie");
    map.put("ziemia", "brzowa");
    map.put("soce", "ciepo");
    try {
      map.put("dodatkowy", "obiekt"); // Przekroczony zakres
    } catch(ArrayIndexOutOfBoundsException e) {
      System.out.println("Zbyt wiele obiektw!");
    }
    System.out.println(map);
    System.out.println(map.get("ocean"));
    monitor.expect(new String[] {
      "Zbyt wiele obiektw!",
      "niebo : niebieskie",
      "trawa : zielona",
      "ocean : niespokojny",
      "drzewo : wysokie",
      "ziemia : brzowa",
      "soce : ciepo",
      "niespokojny"
    });
  }
} ///:~