//: c09:ExtraFeatures.java
// Dalsze upikszenia klas wyjtkw.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class MyException2 extends Exception {
  private int x;
  public MyException2() {}
  public MyException2(String msg) { super(msg); }
  public MyException2(String msg, int x) {
    super(msg);
    this.x = x;
  }
  public int val() { return x; }
  public String getMessage() {
    return "Komunikat szczegowy: "+ x + " "+ super.getMessage();
  }
}

public class ExtraFeatures {
  private static Test monitor = new Test();
  public static void f() throws MyException2 {
    System.out.println("Zgaszam MyException2 w metodzie f()");
    throw new MyException2();
  }
  public static void g() throws MyException2 {
    System.out.println("Zgaszam MyException2 w metodzie g()");
    throw new MyException2("Wyjtek pochodzi z metody g()");
  }
  public static void h() throws MyException2 {
    System.out.println("Zgaszam MyException2 w metodzie h()");
    throw new MyException2("Wyjtek pochodzi z metody h()", 47);
  }
  public static void main(String[] args) {
    try {
      f();
    } catch(MyException2 e) {
      e.printStackTrace();
    }
    try {
      g();
    } catch(MyException2 e) {
      e.printStackTrace();
    }
    try {
      h();
    } catch(MyException2 e) {
      e.printStackTrace();
      System.err.println("e.val() = " + e.val());
    }
    monitor.expect(new String[] {
      "Zgaszam MyException2 w metodzie f()",
      "MyException2: Komunikat szczegowy: 0 null",
      "%% \tat ExtraFeatures.f\\(.*\\)",
      "%% \tat ExtraFeatures.main\\(.*\\)",
      "Zgaszam MyException2 w metodzie g()",
      "MyException2: Komunikat szczegowy: 0 Wyjtek pochodzi z metody g()",
      "%% \tat ExtraFeatures.g\\(.*\\)",
      "%% \tat ExtraFeatures.main\\(.*\\)",
      "Zgaszam MyException2 w metodzie h()",
      "MyException2: Komunikat szczegowy: 47 Wyjtek pochodzi z metody h()",
      "%% \tat ExtraFeatures.h\\(.*\\)",
      "%% \tat ExtraFeatures.main\\(.*\\)",
      "e.val() = 47"
    });
  }
} ///:~
