//: c09:AlwaysFinally.java
// Sekcja finally jest wykonywana zawsze.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class FourException extends Exception {}

public class AlwaysFinally {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    System.out.println("Wchodz do pierwszego bloku try");
    try {
      System.out.println("Wchodz do drugiego bloku try");
      try {
        throw new FourException();
      } finally {
        System.out.println("Sekcja finally w drugim bloku try");
      }
    } catch(FourException e) {
      System.err.println(
        "Wyjtek FourException przechwycony w pierwszym bloku try");
    } finally {
      System.err.println("Sekcja finally w pierwszym bloku try");
    }
    monitor.expect(new String[] {
      "Wchodz do pierwszego bloku try",
      "Wchodz do drugiego bloku try",
      "Sekcja finally w drugim bloku try",
      "Wyjtek FourException przechwycony w pierwszym bloku try",
      "Sekcja finally w pierwszym bloku try"
    });
  }
} ///:~
