//: c06:PlaceSetting.java
// czenie kompozycji i dziedziczenia.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Plate {
  Plate(int i) {
    System.out.println("Konstruktor klasy Plate");
  }
}

class DinnerPlate extends Plate {
  DinnerPlate(int i) {
    super(i);
    System.out.println("Konstruktor klasy DinnerPlate");
  }
}

class Utensil {
  Utensil(int i) {
    System.out.println("Konstruktor klasy Utensil");
  }
}

class Spoon extends Utensil {
  Spoon(int i) {
    super(i);
    System.out.println("Konstruktor klasy Spoon");
  }
}

class Fork extends Utensil {
  Fork(int i) {
    super(i);
    System.out.println("Konstruktor klasy Fork");
  }
}

class Knife extends Utensil {
  Knife(int i) {
    super(i);
    System.out.println("Konstruktor klasy Knife");
  }
}

// Kulturalny sposb na wykonanie czego:
class Custom {
  Custom(int i) {
    System.out.println("Konstruktor klasy Custom");
  }
}

public class PlaceSetting extends Custom {
  private static Test monitor = new Test();
  private Spoon sp;
  private Fork frk;
  private Knife kn;
  private DinnerPlate pl;
  public PlaceSetting(int i) {
    super(i + 1);
    sp = new Spoon(i + 2);
    frk = new Fork(i + 3);
    kn = new Knife(i + 4);
    pl = new DinnerPlate(i + 5);
    System.out.println("Konstruktor klasy PlaceSetting");
  }
  public static void main(String[] args) {
    PlaceSetting x = new PlaceSetting(9);
    monitor.expect(new String[] {
      "Konstruktor klasy Custom",
      "Konstruktor klasy Utensil",
      "Konstruktor klasy Spoon",
      "Konstruktor klasy Utensil",
      "Konstruktor klasy Fork",
      "Konstruktor klasy Utensil",
      "Konstruktor klasy Knife",
      "Konstruktor klasy Plate",
      "Konstruktor klasy DinnerPlate",
      "Konstruktor klasy PlaceSetting"
    });
  }
} ///:~
