//: c15:SimpleFilter.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.logging.*;

public class SimpleFilter {
  private static Test monitor = new Test();
  private static Logger logger =
    Logger.getLogger("SimpleFilter");
  static class Duck {};
  static class Wombat {};
  static void sendLogMessages() {
    logger.log(Level.WARNING,
      "Kaczka w domu!", new Duck());
    logger.log(Level.WARNING,
      "Wombat na wolnoci!", new Wombat());
  }
  public static void main(String[] args) {
    sendLogMessages();
    logger.setFilter(new Filter() {
      public boolean isLoggable(LogRecord record) {
        Object[] params = record.getParameters();
        if(params == null)
          return true; // Bez parametrw
        if(record.getParameters()[0] instanceof Duck)
          return true;  // Rejestrujemy tylko informacje 
                        // o obiekatach Duck
        return false;
      }
    });
    logger.info("Po zastosowaniu filtra...");
    sendLogMessages();
    monitor.expect(new String[] {
      "%% .* SimpleFilter sendLogMessages",
      "WARNING: Kaczka w domu!",
      "%% .* SimpleFilter sendLogMessages",
      "WARNING: Wombat na wolnoci!",
      "%% .* SimpleFilter main",
      "INFO: Po zastosowaniu filtra...",
      "%% .* SimpleFilter sendLogMessages",
      "WARNING: Kaczka w domu!"
    });
  }
} ///:~
