//: c13:SerialNumberChecker.java
// W przypadku wykorzystania wtkw, operacje
// ktre mog si wydawa bezpiecznie, bezpiecznymi nie s.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.

// Wielokrotnie wykorzystuje przydzielon mu pami,
// dziki czemu nie spowoduje wyczerpania pamici.
class CircularSet {
  private int[] array;
  private int len;
  private int index = 0;
  public CircularSet(int size) {
    array = new int[size];
    len = size;
    // Pocztkowe zapisanie wartoci, ktre na pewno
    // nie bd generowane przez SerialNumberGenerator:
    for(int i = 0; i < size; i++)
      array[i] = -1;
  }
  public synchronized void add(int i) {
    array[index] = i;
    // Przesunicie licznika na pocztek, by przesania
    // stare elementy
    index = ++index % len;
  }
  public synchronized boolean contains(int val) {
    for(int i = 0; i < len; i++)
      if(array[i] == val) return true;
    return false;
  }
}

public class SerialNumberChecker {
  private static CircularSet serials =
    new CircularSet(1000);
  static class SerialChecker extends Thread {
    SerialChecker() { start(); }
    public void run() {
      while(true) {
        int serial =
          SerialNumberGenerator.nextSerialNumber();
        if(serials.contains(serial)) {
          System.out.println("Duplikat: " + serial);
          System.exit(0);
        }
        serials.add(serial);
      }
    }
  }
  public static void main(String[] args) {
    for(int i = 0; i < 10; i++)
      new SerialChecker();
    // Przerwij po 4 sekundach:
    new Timeout(4000, "Nie wykryto duplikatw");
  }
} ///:~
