//: c13:Interrupt.java
// Zastosowanie interrupt() aby przerwa zablokowany wtek.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;

class Blocked extends Thread {
  public Blocked() {
    System.out.println("Uruchamianie wtku Blocked");
    start();
  }
  public void run() {
    try {
      synchronized(this) {
        wait(); // blokujemy wtek
      }
    } catch(InterruptedException e) {
      System.out.println("Wtek przerwany");
    }
    System.out.println("Zakaczanie metody run()");
  }
}

public class Interrupt {
  static Blocked blocked = new Blocked();
  public static void main(String[] args) {
    new Timer(true).schedule(new TimerTask() {
      public void run() {
        System.out.println("Przygotowanie do przerwania");
        blocked.interrupt();
        blocked = null; // by zwolni
      }
    }, 2000); // wywoanie run() po 2000 milisekund
  }
} ///:~
