//: c12:ZipCompress.java
// Wykorzystanie formatu Zip dla kompresji 
// dowolnej liczby plikw podanych z wiersza polece.
// {Argumenty wywoania: ZipCompress.java}
// {Porzdki: test.zip}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

public class ZipCompress {
  private static Test monitor = new Test();
  // Komunikaty wyjtkw wypisywane s na konsol:
  public static void main(String[] args)
  throws IOException {
    FileOutputStream f = new FileOutputStream("test.zip");
    CheckedOutputStream csum =
      new CheckedOutputStream(f, new Adler32());
     ZipOutputStream zos = new ZipOutputStream(csum);
     BufferedOutputStream out =
      new BufferedOutputStream(zos);
    zos.setComment("Test Zipowania za pomoc Javy");
    // Nie ma odpowiadajcego getComment()
    for(int i = 0; i < args.length; i++) {
      System.out.println("Zapis do pliku " + args[i]);
    BufferedInputStream in = new BufferedInputStream(
      new FileInputStream(args[i]));
      zos.putNextEntry(new ZipEntry(args[i]));
      int c;
      while((c = in.read()) != -1)
        out.write(c);
      in.close();
    }
    out.close();
    // Suma kontrolna wana tylko po  zamkniciu pliku!
    System.out.println("Suma kontrolna: " +
      csum.getChecksum().getValue());
    // Teraz s pobierane pliki:
    System.out.println("Odczyt pliku");
    FileInputStream fi = new FileInputStream("test.zip");
    CheckedInputStream csumi =
      new CheckedInputStream(fi, new Adler32());
    ZipInputStream in2 = new ZipInputStream(csumi);
    BufferedInputStream bis = new BufferedInputStream(in2);
    ZipEntry ze;
    while((ze = in2.getNextEntry()) != null) {
      System.out.println("Odczytywanie pliku " + ze);
      int x;
      while((x = bis.read()) != -1)
        System.out.write(x);
    }
    if(args.length == 1)
      monitor.expect(new String[] {
        "Zapis do pliku " + args[0],
        "%% Suma kontrolna: \\d+",
        "Odczyt pliku",
        "Odczytywanie pliku " + args[0]}, args[0]);
    System.out.println("Suma kontrolna: " +
      csumi.getChecksum().getValue());
    bis.close();
    // Alternatywny sposb otwierania i odczytu plikw zip:
    ZipFile zf = new ZipFile("test.zip");
    Enumeration e = zf.entries();
    while(e.hasMoreElements()) {
      ZipEntry ze2 = (ZipEntry)e.nextElement();
      System.out.println("Plik: " + ze2);
      // ... i ekstrakcja danych jak przedtem
    }
    if(args.length == 1)
      monitor.expect(new String[] {
        "%% Suma kontrolna: \\d+",
        "Plik: " + args[0]
      });
  }
} ///:~