//: c12:TheReplacements.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.regex.*;
import java.io.*;
import com.bruceeckel.util.*;
import com.bruceeckel.simpletest.*;

/*! Oto blok tekstu, ktry zostanie wykorzystany
    jako acuch wejciowy w operacjach na wyraeniach
    regularnych. Program w pierwszej kolejnoci  
    pobierze zawarto bloku poszukujc specjalnych 
    ogranicznikw, a nastpnie wykorzysta j 
    w dalszych operacjach !*/

public class TheReplacements {
  private static Test monitor = new Test();
  public static void main(String[] args) throws Exception {
    String s = TextFile.read("TheReplacements.java");
    // Odpowiada blokowi tekstu zakomentowanemu 
    // w szczeglny sposb:
    Matcher mInput =
      Pattern.compile("/\\*!(.*)!\\*/", Pattern.DOTALL)
        .matcher(s);
    if(mInput.find())
      s = mInput.group(1); // Pobrany przez grup w nawiasach
    // Zastpuje dwa lub wiecej odstpw jednym znakiem odstpu
    s = s.replaceAll(" {2,}", " ");
    // Usuwa wszelkie ostpy z pocztku wiersza.
    // Koniecznie naley wykorzysta tryb MULTILINE
    s = s.replaceAll("(?m)^ +", "");
    System.out.println(s);
    s = s.replaceFirst("[aeiou]", "(SAMOGOSKI1)");
    StringBuffer sbuf = new StringBuffer();
    Pattern p = Pattern.compile("[aeiou]");
    Matcher m = p.matcher(s);
    // Przetwarzanie informacji podczas realizacji 
    // operacji zastpowania
    while(m.find())
      m.appendReplacement(sbuf, m.group().toUpperCase());
    // Dodanie pozostaej czci acucha wejciowego:
    m.appendTail(sbuf);
    System.out.println(sbuf);
    monitor.expect(new String[]{
      "Oto blok tekstu, ktry zostanie wykorzystany",
      "jako acuch wejciowy w operacjach na wyraeniach",
      "regularnych. Program w pierwszej kolejnoci ",
      "pobierze zawarto bloku poszukujc specjalnych ",
      "ogranicznikw, a nastpnie wykorzysta j ",
      "w dalszych operacjach ",
      "Ot(SAMOGOSKI1) blOk tEkstU, ktry zOstAnIE wykOrzystAny",
      "jAkO AcUch wEjcIOwy w OpErAcjAch nA wyrAEnIAch",
      "rEgUlArnych. PrOgrAm w pIErwszEj kOlEjnOcI ",
      "pObIErzE zAwArtO blOkU pOszUkUjc spEcjAlnych ",
      "OgrAnIcznIkw, A nAstpnIE wykOrzystA j ",
      "w dAlszych OpErAcjAch "
    });
  }
} ///:~
