//: c12:PreferencesDemo.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.prefs.*;
import java.util.*;

public class PreferencesDemo {
  public static void main(String[] args) throws Exception {
    Preferences prefs = Preferences
      .userNodeForPackage(PreferencesDemo.class);
    prefs.put("Pooenie", "Oz");
    prefs.put("Obuwie", "Ruby Slippers");
    prefs.putInt("Towarzysze", 4);
    prefs.putBoolean("Czy tam s wiedmy?", true);
    int usageCount = prefs.getInt("IloscZastosowa", 0);
    usageCount++;
    prefs.putInt("IloscZastosowa", usageCount);
    Iterator it = Arrays.asList(prefs.keys()).iterator();
    while(it.hasNext()) {
      String key = it.next().toString();
      System.out.println(key + ": "+ prefs.get(key, null));
    }
    // Zawsze naley poda warto domyln:
    System.out.println(
      "Ilu towarzyszy miaa Dorotka? " + 
      prefs.getInt("Towarzysze", 0));
  }
} ///:~