//: c12:ChannelCopy.java
// Kopiowanie pliku przy uyciu kanaw i buforw
// {Argumenty wywoania: ChannelCopy.java test.txt}
// {Porzdki: test.txt} 
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.io.*;
import java.nio.*;
import java.nio.channels.*;

public class ChannelCopy {
  private static final int BSIZE = 1024;
  public static void main(String[] args) throws Exception {
    if(args.length != 2) {
      System.out.println("Argumenty: plikrdowy plikDocelowy");
      System.exit(1);
    }
    FileChannel 
      in = new FileInputStream(args[0]).getChannel(),
      out = new FileOutputStream(args[1]).getChannel();
    ByteBuffer buffer = ByteBuffer.allocate(BSIZE);
    while(in.read(buffer) != -1) {
      buffer.flip(); // Przygotowanie do zapisu
      out.write(buffer);
      buffer.clear();  // Przygotowanie do odczytu
    }
  }
} ///:~