//: c11:IceCream.java
// Tablice jako wartoci zwracane przez metody.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;

public class IceCream {
  private static Test monitor = new Test();
  private static Random rand = new Random();
  public static final String[] flavors = {
    "Czekoladowe", "Truskawkowe",
    "Karmel Waniliowy", "Mitowa Kostka",
    "Karmel Mokka-Migdaowy", "Rumowy Rodzynek",
    "Krem Pralinkowy", "Borwkowe Ciastko" 
  };
  public static String[] flavorSet(int n) {
    String[] results = new String[n];
    boolean[] picked = new boolean[flavors.length];
    for(int i = 0; i < n; i++) {
      int t;
      do
        t = rand.nextInt(flavors.length);
      while(picked[t]);
      results[i] = flavors[t];
      picked[t] = true;
    }
    return results;
  }
  public static void main(String[] args) {
    for(int i = 0; i < 20; i++) {
      System.out.println(
        "flavorSet(" + i + ") = ");
      String[] fl = flavorSet(flavors.length);
      for(int j = 0; j < fl.length; j++)
        System.out.println("\t" + fl[j]);
      monitor.expect(new Object[] {
        "%% flavorSet\\(\\d+\\) = ",
        new TestExpression("%% \\t(Czekoladowe|Truskawkowe|"
          + "Karmel Waniliowy|Mitowa Kostka|Karmel Mokka-Migdaowy"
          + "|Rumowy Rodzynek|Krem Pralinkowy|Borwkowe Ciastko)", 8)
      });
    }
  }
} ///:~
