//: c09:Rethrowing.java
// Demonstracja metody fillInStackTrace()
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

public class Rethrowing {
  private static Test monitor = new Test();
  public static void f() throws Exception {
    System.out.println("utworzenie wyjtku w metodzie f()");
    throw new Exception("zgoszony w metodzie f()");
  }
  public static void g() throws Throwable {
    try {
      f();
    } catch(Exception e) {
      System.err.println("W metodzie g(),e.printStackTrace()");
      e.printStackTrace();
      throw e; // 17
      // throw e.fillInStackTrace(); // 18
    }
  }
  public static void
  main(String[] args) throws Throwable {
    try {
      g();
    } catch(Exception e) {
      System.err.println(
        "Wyjtek przechwycony w main(), e.printStackTrace()");
      e.printStackTrace();
    }
    monitor.expect(new String[] {
      "utworzenie wyjtku w metodzie f()",
      "W metodzie g(),e.printStackTrace()",
      "java.lang.Exception: zgoszony w metodzie f()",
      "%% \tat Rethrowing.f(.*?)",
      "%% \tat Rethrowing.g(.*?)",
      "%% \tat Rethrowing.main(.*?)",
      "Wyjtek przechwycony w main(), e.printStackTrace()",
      "java.lang.Exception: zgoszony w metodzie f()",
      "%% \tat Rethrowing.f(.*?)",
      "%% \tat Rethrowing.g(.*?)",
      "%% \tat Rethrowing.main(.*?)"
    });
  }
} ///:~
