//: c09:NeverCaught.java
// Ignorowanie wyjtkw RuntimeExceptions.
// {Wykonanie programu powoduje zgoszenie wyjtku}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

public class NeverCaught {
  private static Test monitor = new Test();
  static void f() {
    throw new RuntimeException("Jestem z f()");
  }
  static void g() {
    f();
  }
  public static void main(String[] args) {
    g();
    monitor.expect(new String[] {
      "Exception in thread \"main\" " +
      "java.lang.RuntimeException: Jestem z f()",
      "        at NeverCaught.f(NeverCaught.java:7)",
      "        at NeverCaught.g(NeverCaught.java:10)",
      "        at NeverCaught.main(NeverCaught.java:13)"
    });
  }
} ///:~
