//: c09:FinallyWorks.java
// Sekcja finally jest wykonywana zawsze.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class ThreeException extends Exception {}

public class FinallyWorks {
  private static Test monitor = new Test();
  static int count = 0;
  public static void main(String[] args) {
    while(true) {
      try {
        // Przy postinkrementacji zero jest ju na pocztku:
        if(count++ == 0)
          throw new ThreeException();
        System.out.println("Nie ma wyjtku");
      } catch(ThreeException e) {
        System.err.println("ThreeException");
      } finally {
        System.err.println("Jestem w sekcji finally");
        if(count == 2) break; // poza "while"
      }
    }
    monitor.expect(new String[] {
      "ThreeException",
      "Jestem w sekcji finally",
      "Nie ma wyjtku",
      "Jestem w sekcji finally"
    });
  }
} ///:~
