//: c09:ExceptionMethods.java
// Demonstracja metod klasy Exception.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

public class ExceptionMethods {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    try {
      throw new Exception("Oto mj Wyjtek");
    } catch(Exception e) {
      System.err.println("Zapaem wyjtek");
      System.err.println("getMessage():" + e.getMessage());
      System.err.println("getLocalizedMessage():" +
        e.getLocalizedMessage());
      System.err.println("toString():" + e);
      System.err.println("printStackTrace():");
      e.printStackTrace();
    }
    monitor.expect(new String[] {
      "Zapaem wyjtek",
      "getMessage():Oto mj Wyjtek",
      "getLocalizedMessage():Oto mj Wyjtek",
      "toString():java.lang.Exception: Oto mj Wyjtek",
      "printStackTrace():",
      "java.lang.Exception: Oto mj Wyjtek",
      "%% \tat ExceptionMethods.main\\(.*\\)"
    });
  }
} ///:~
