//: c09:Cleanup.java
// Zwracaj uwag na wyjtki w konstruktorach.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;

class InputFile {
  private BufferedReader in;
  public InputFile(String fname) throws Exception {
    try {
      in = new BufferedReader(new FileReader(fname));
      // Inny kod, ktry moe zgasza wyjtki
    } catch(FileNotFoundException e) {
      System.err.println("Nie mona otworzy " + fname);
      // Nie by otwarty, wic go nie zamykaj
      throw e;
    } catch(Exception e) {
      // Wszystkie inne wyjtki musz zamkn plik
      try {
        in.close();
      } catch(IOException e2) {
        System.err.println("wywoanie in.close() nie powiodo si");
      }
      throw e; // Zgo ponownie
    } finally {
      // Tutaj nie zamykaj pliku!!!
    }
  }
  public String getLine() {
    String s;
    try {
      s = in.readLine();
    } catch(IOException e) {
      throw new RuntimeException("Wywoanie getLine() nie powiodo si");
    }
    return s;
  }
  public void dispose() {
    try {
      in.close();
      System.out.println("Wywoanie dispose() zakoczone pomylnie");
    } catch(IOException e2) {
      throw new RuntimeException("Wywoanie in.close() nie powiodo si");
    }
  }
}

public class Cleanup {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    try {
      InputFile in = new InputFile("Cleanup.java");
      String s;
      int i = 1;
      while((s = in.getLine()) != null)
        ; // Tutaj wiersz po wierszu przetwarzamy zawarto pliku
      in.dispose();
    } catch(Exception e) {
      System.err.println("Wyjtek Exception przechwycony w metodzie main");
      e.printStackTrace();
    }
    monitor.expect(new String[] {
      "Wywoanie dispose() zakoczone pomylnie"
    });
  }
} ///:~