//: c07:RTTI.java
// Rzutowanie w d i identyfikacja typu 
// w czasie wykonania (RTTI).
// {Zgasza wyjtek}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.

class Useful {
  public void f() {}
  public void g() {}
}

class MoreUseful extends Useful {
  public void f() {}
  public void g() {}
  public void u() {}
  public void v() {}
  public void w() {}
}

public class RTTI {
  public static void main(String[] args) {
    Useful[] x = {
      new Useful(),
      new MoreUseful()
    };
    x[0].f();
    x[1].g();
    // Bd w czasie kompilacji: brak metody "u" w Useful:
    //! x[1].u();
    ((MoreUseful)x[1]).u(); // Rzutowanie w d/RTTI
    ((MoreUseful)x[0]).u(); // Zgoszenie wyjtku
  }
} ///:~
