//: c07:Frog.java
// Sprztanie i dziedziczenie.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Characteristic {
  private String s;
  Characteristic(String s) {
    this.s = s;
    System.out.println("Tworzenie obiektu Cecha (Characteristic) " + s);
  }
  protected void dispose() {
    System.out.println("Usuwanie obiektu Cecha " + s);
  }
}

class Description {
  private String s;
  Description(String s) {
    this.s = s;
    System.out.println("Tworzenie obiektu Opis (Description) " + s);
  }
  protected void dispose() {
    System.out.println("Usuwanie obiektu Opis " + s);
  }
}

class LivingCreature {
  private Characteristic p = new Characteristic("yje");
  private Description t =
    new Description("Obiekty Stworzenieywe (LivingCreature)");
  LivingCreature() {
    System.out.println("LivingCreature()");
  }
  protected void dispose() {
    System.out.println("Usuwanie obiektu Stworzenieywe ");
    t.dispose();
    p.dispose();
  }
}

class Animal extends LivingCreature {
  private Characteristic p= new Characteristic("ma serce");
  private Description t =
    new Description("Zwierze (Animal) a nie Rolina (Vegetable)");
  Animal() {
    System.out.println("Animal()");
  }
  protected void dispose() {
    System.out.println("Usuwanie obiektu Zwierze");
    t.dispose();
    p.dispose();
    super.dispose();
  }
}

class Amphibian extends Animal {
  private Characteristic p =
    new Characteristic("moe y w wodzie");
  private Description t =
    new Description("Zarwno na ldzie jak i w wodzie");
  Amphibian() {
    System.out.println("Amphibian()");
  }
  protected void dispose() {
    System.out.println("Usuwanie obiektu ZwierzeZiemnoWodne");
    t.dispose();
    p.dispose();
    super.dispose();
  }
}

public class Frog extends Amphibian {
  private static Test monitor = new Test();
  private Characteristic p = new Characteristic("Rechocz");
  private Description t = new Description("Jedz robaki");
  public Frog() {
    System.out.println("Frog()");
  }
  protected void dispose() {
    System.out.println("Usuwanie obiektu aba");
    t.dispose();
    p.dispose();
    super.dispose();
  }
  public static void main(String[] args) {
    Frog frog = new Frog();
    System.out.println("Cze!");
    frog.dispose();
    monitor.expect(new String[] {
      "Tworzenie obiektu Cecha (Characteristic) yje",
      "Tworzenie obiektu Opis (Description) Obiekty Stworzenieywe (LivingCreature)",
      "LivingCreature()",
      "Tworzenie obiektu Cecha (Characteristic) ma serce",
      "Tworzenie obiektu Opis (Description) Zwierze (Animal) a nie Rolina (Vegetable)",
      "Animal()",
      "Tworzenie obiektu Cecha (Characteristic) moe y w wodzie",
      "Tworzenie obiektu Opis (Description) Zarwno na ldzie jak i w wodzie",
      "Amphibian()",
      "Tworzenie obiektu Cecha (Characteristic) Rechocz",
      "Tworzenie obiektu Opis (Description) Jedz robaki",
      "Frog()",
      "Cze!",
      "Usuwanie obiektu aba",
      "Usuwanie obiektu Opis Jedz robaki",
      "Usuwanie obiektu Cecha Rechocz",
      "Usuwanie obiektu ZwierzeZiemnoWodne",
      "Usuwanie obiektu Opis Zarwno na ldzie jak i w wodzie",
      "Usuwanie obiektu Cecha moe y w wodzie",
      "Usuwanie obiektu Zwierze",
      "Usuwanie obiektu Opis Zwierze (Animal) a nie Rolina (Vegetable)",
      "Usuwanie obiektu Cecha ma serce",
      "Usuwanie obiektu Stworzenieywe ",
      "Usuwanie obiektu Opis Obiekty Stworzenieywe (LivingCreature)",
      "Usuwanie obiektu Cecha yje"
    });
  }
} ///:~
