//: c06:FinalData.java
// Skutek zastosowania final dla pl.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;

class Value {
  int i; // Dostp pakietowy
  public Value(int i) { this.i = i; }
}

public class FinalData {
  private static Test monitor = new Test();
  private static Random rand = new Random();
  private String id;
  public FinalData(String id) { this.id = id; }
  // To mog by stae czasu kompilacji:
  private final int VAL_ONE = 9;
  private static final int VAL_TWO = 99;
  // Typowa staa publiczna:
  public static final int VAL_THREE = 39;
  // To nie mog by stae czasu kompilacji:
  private final int i4 = rand.nextInt(20);
  static final int i5 = rand.nextInt(20);
  private Value v1 = new Value(11);
  private final Value v2 = new Value(22);
  private static final Value v3 = new Value(33);
  // Tablice:
  private final int[] a = { 1, 2, 3, 4, 5, 6 };
  public String toString() {
    return id + ": " + "i4 = " + i4 + ", i5 = " + i5;
  }
  public static void main(String[] args) {
    FinalData fd1 = new FinalData("fd1");
    //! fd1.VAL_ONE++; // Bd - nie mona zmieni wartoci
    fd1.v2.i++; // Obiekt nie jest stay!
    fd1.v1 = new Value(9); // OK -- nie finalny
    for(int i = 0; i < fd1.a.length; i++)
      fd1.a[i]++; // Obiekt nie jest stay!
    //! fd1.v2 = new Value(0); // Bd: Nie mona 
    //! fd1.v3 = new Value(1); // zamieni referencji
    //! fd1.a = new int[3];
    System.out.println(fd1);
    System.out.println("Tworzenie nowego obiektu FinalData");
    FinalData fd2 = new FinalData("fd2");
    System.out.println(fd1);
    System.out.println(fd2);
    monitor.expect(new String[] {
      "%% fd1: i4 = \\d+, i5 = \\d+",
      "Tworzenie nowego obiektu FinalData",
      "%% fd1: i4 = \\d+, i5 = \\d+",
      "%% fd2: i4 = \\d+, i5 = \\d+"
    });
  }
} ///:~
