//: c06:FinalArguments.java
// Uycie "final" w argumentach metod.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.

class Gizmo {
  public void spin() {}
}

public class FinalArguments {
  void with(final Gizmo g) {
    //! g = new Gizmo(); // Niepoprawne -- g jest finalna
  }
  void without(Gizmo g) {
    g = new Gizmo(); // OK -- g nie jest finalna
    g.spin();
  }
  // void f(final int i) { i++; } // Nie mona zmieni
  // Mona jedynie odczyta warto zmiennej finalnej:
  int g(final int i) { return i + 1; }
  public static void main(String[] args) {
    FinalArguments bf = new FinalArguments();
    bf.without(null);
    bf.with(null);
  }
} ///:~
