
//: C09:VirtInit.cpp
// Ilustracja procesu inicjalizacji w hierarchii z wirtualnymi klasami bazowymi
#include <iostream>
#include <string>
using namespace std;

class M {
public:
  M(const string& s) {
    cout << "M " << s << endl;
  }
};

class A{
  M m;
public:
  A(const string& s) : m("w A") {
     cout << "A " << s << endl;
  }
  virtual ~A() {}
};

class B
{
  M m;
public:
  B(const string& s) : m("w B")  {
    cout << "B " << s << endl;
  }
  virtual ~B() {}
};

class C
{
  M m;
public:
  C(const string& s) : m("w C")  {
    cout << "C " << s << endl;
  }
  virtual ~C() {}
};

class D
{
  M m;
public:
  D(const string& s) : m("w D") {
    cout << "D " << s << endl;
  }
  virtual ~D() {}
};

class E : public A, virtual public B, virtual public C
{
  M m;
public:
  E(const string& s)
  : A("z E"), B("z E"), C("z E"), m("w E") {
    cout << "E " << s << endl;
  }
};

class F : virtual public B, virtual public C, public D
{
  M m;
public:
  F(const string& s)
  : B("z F"), C("z F"), D("z F"), m("w F") {
    cout << "F " << s << endl;
  }
};

class G : public E, public F
{
  M m;
public:
  G(const string& s)
  : B("z G"), C("z G"), E("z G"),
    F("z G"), m("w G") {
    cout << "G " << s << endl;
  }
};

int main() {
  G g("z main()");
} ///:~
