
//: C08:TypeInfo.cpp
// Ilustracja zastosowania operatora typeid
#include <iostream>
#include <typeinfo>
using namespace std;

struct PolyBase {virtual ~PolyBase(){}};
struct PolyDer : PolyBase { PolyDer() {} };
struct NonPolyBase {};
struct NonPolyDer : NonPolyBase {NonPolyDer(int){}};

int main() {
  // Test typw polimorficznych
  const PolyDer pd;
  const PolyBase* ppb = &pd;
  cout << typeid(ppb).name() << endl;
  cout << typeid(*ppb).name() << endl;
  cout << boolalpha << (typeid(*ppb) == typeid(pd))
    << endl;
  cout << (typeid(PolyDer) == typeid(const PolyDer))
    << endl;
  // Test typw niepolimorficznych
  const NonPolyDer npd(1);
  const NonPolyBase* nppb = &npd;
  cout << typeid(nppb).name() << endl;
  cout << typeid(*nppb).name() << endl;
  cout << (typeid(*nppb) == typeid(npd))
    << endl;
  // Test typu wbudowanego
  int i;
  cout << typeid(i).name() << endl;
} ///:~
