
//: C07:WildLifeMonitor.cpp
#include <algorithm>
#include <cstdlib>
#include <cstddef>
#include <ctime>
#include <iostream>
#include <iterator>
#include <map>
#include <sstream>
#include <string>
#include <vector>
using namespace std;

class DataPoint {
  int x, y; // Miejsce obserwacji
  time_t time; // Czas obserwacji
public:
  DataPoint() : x(0), y(0), time(0) {}
  DataPoint(int xx, int yy, time_t tm) :
    x(xx), y(yy), time(tm) {}
  // Syntetyzowane: konstruktor kopiujcy i operator przypisania
  // s wystarczajce
  int getX() const { return x; }
  int getY() const { return y; }
  const time_t* getTime() const { return &time; }
};

string animal[] = {
  "chomik", "bbr", "wistak", "asica",
  "wiewirka", "wrbel", "niedwied", "orze",
  "jastrzb", "mysz", "sarna", "wydra", "gil",
};

const int asz = sizeof animal/sizeof *animal;
vector<string> animals(animal, animal + asz);

// Wszystkie informacje o obserwacji kompletowane s w obiekcie
// Sighting wyposaonym w moliwo zapisania wartoci
// do strumienia wyjciowego:

typedef pair<string, DataPoint> Sighting;

ostream&
operator<<(ostream& os, const Sighting& s) {
  return os << s.first << " zauwaony w x= " <<
    s.second.getX() << ", y= " << s.second.getY()
    << ", o czasie = " << ctime(s.second.getTime());
}

// Generator obiektw Sighting:
class SightingGen {
  vector<string>& animals;
  enum { d = 100 };
public:
  SightingGen(vector<string>& an) :
    animals(an) {}
  Sighting operator()() {
    Sighting result;
    int select = rand() % animals.size();
    result.first = animals[select];
    result.second = DataPoint(
      rand() % d, rand() % d, time(0));
    return result;
  }
};

// Wywietlenie listy gatunkw do wyboru, pozwala uytkownikowi
// na wybranie gatunku; zwraca indeks gatunku
int menu() {
  cout << "wybierz gatunek ('q'  koniec): ";
  for(size_t i = 0; i < animals.size(); i++)
    cout <<'['<< i <<']'<< animals[i] << ' ';
  cout << endl;
  string reply;
  cin >> reply;
  if(reply.at(0) == 'q') return 0;
  istringstream r(reply);
  int i;
  r >> i; // Konwersja do typu int
  i %= animals.size();
  return i;
}
      
int main() {
typedef multimap<string, DataPoint> DataMap;
typedef DataMap::iterator DMIter;
  DataMap sightings;
  srand(time(0)); // Losowo
  generate_n(
    inserter(sightings, sightings.begin()),
    50, SightingGen(animals));
  // Wypisanie wszystkich obserwacji:
  copy(sightings.begin(), sightings.end(),
    ostream_iterator<Sighting>(cout, ""));
  // Wywietlenie obserwacji wystpie zadanego gatunku:
  for(int count = 1; count < 10; count++) {
    // Wybr gatunku za porednictwem menu:
    // int i = menu();
    // Generator wyboru losowego (automatyzuje testowanie):
    int i = rand() % animals.size();
    // Iteratory w parze range odnosz si do elementw: 
    // pierwszego i "nastpnego za" ostatnim:
    pair<DMIter, DMIter> range =
      sightings.equal_range(animals[i]);
    copy(range.first, range.second,
      ostream_iterator<Sighting>(cout, ""));
  }
} ///:~
