
//: C07:BankTeller.cpp
// Kolejka i symulowana wielowtkowo w modelu
// systemu kasjer-klient
#include <cstdlib>
#include <ctime>
#include <iostream>
#include <iterator>
#include <list>
#include <queue>
using namespace std;

class Customer {
  int serviceTime;
public:
  Customer() : serviceTime(0) {}
  Customer(int tm) : serviceTime(tm) {}
  int getTime() { return serviceTime; }
  void setTime(int newtime) {
    serviceTime = newtime;
  }
  friend ostream&
  operator<<(ostream& os, const Customer& c) {
    return os << '[' << c.serviceTime << ']';
  }
};

class Teller {
  queue<Customer>& customers;
  Customer current;
  enum { slice = 5 };
  int ttime; // Czas do dyspozycji "wtku"
  bool busy; // Znacznik zajtoci kasjera
public:
  Teller(queue<Customer>& cq)
    : customers(cq), ttime(0), busy(false) {}
  Teller& operator=(const Teller& rv) {
    customers = rv.customers;
    current = rv.current;
    ttime = rv.ttime;
    busy = rv.busy;
    return *this;
  }
  bool isBusy() { return busy; }
  void run(bool recursion = false) {
    if(!recursion)
      ttime = slice;
    int servtime = current.getTime();
    if(servtime > ttime) {
      servtime -= ttime;
      current.setTime(servtime);
      busy = true; // Obsuga klienta bdzie kontynuwana w nastpnym uruchomieniu
      return;
    }
    if(servtime < ttime) {
      ttime -= servtime;
      if(!customers.empty()) {
        current = customers.front();
        customers.pop(); // Usunicie klienta z kolejki
        busy = true;
        run(true); // Rekurencja
      }
      return;
    }
    if(servtime == ttime) {
      // Klient zosta obsuony:
      current = Customer(0);
      busy = false;
      return; // Czas procesora wyczerpany
    }
  }
};

// Dziedziczenie udostpnia skadowe prywatne:
class CustomerQ : public queue<Customer> {
public:
  friend ostream&
  operator<<(ostream& os, const CustomerQ& cd) {
    copy(cd.c.begin(), cd.c.end(),
      ostream_iterator<Customer>(os, ""));
    return os;
  }
};

int main() {
  CustomerQ customers;
  list<Teller> tellers;
  typedef list<Teller>::iterator TellIt;
  tellers.push_back(Teller(customers));
  srand(time(0)); // Inicjalizacja generatora losowego
  clock_t ticks = clock();
  // Uruchomienie symulacji na przynajmniej 5 sekund:
  while(clock() < ticks + 5 * CLOCKS_PER_SEC) {
    // Dodanie losowej liczby klientw do kolejki
    // i ustawienie dla klientw losowych czasw obsugi:
    for(int i = 0; i < rand() % 5; i++)
      customers.push(Customer(rand() % 15 + 1));
    cout << '{' << tellers.size() << '}'
      << customers << endl;
    // Kasjerzy mog rozpocz "obsug" klientw:
    for(TellIt i = tellers.begin();
      i != tellers.end(); i++)
      (*i).run();
    cout << '{' << tellers.size() << '}'
      << customers << endl;
    // Jeeli kolejka jest za duga, trzeba otworzy kolejne okienko:
    if(customers.size() / tellers.size() > 2)
      tellers.push_back(Teller(customers));
    // Jeeli kolejka jest krtka mona zamkn okienko kasowe:
    if(tellers.size() > 1 &&
      customers.size() / tellers.size() < 2)
      for(TellIt i = tellers.begin();
        i != tellers.end(); i++)
        if(!(*i).isBusy()) {
          tellers.erase(i);
          break; // Wyjcie z ptli
        }
  }
} ///:~
