
//: C06:Comparison.cpp
// Algorytmy porwnujce sekwencje
#include <algorithm>
#include <functional>
#include <string>
#include <vector>
#include "PrintSequence.h"
using namespace std;

int main() {
  // Obiekty klasy string s prostymi w uyciu kontenerami dla sekwencji
  // znakw, ale poza tym przykadem warto poszuka zastpnika algorytmu
  // STL w metodach samej klasy string:
  string s1("To jest test ");
  string s2("To jest Test ");
  cout << "s1: " << s1 << endl
    << "s2: " << s2 << endl;
  cout << "porwnanie s1 z s1 (equal): "
    << equal(s1.begin(), s1.end(), s1.begin())
    << endl;
  cout << "porwnanie s1 z s2 (equal): "
    << equal(s1.begin(), s1.end(), s2.begin())
    << endl;

  cout << "porwnanie (lexicographical_compare) s1 z s1: " <<
    lexicographical_compare(s1.begin(), s1.end(),
      s1.begin(), s1.end()) <<  endl;
  cout << "porwnanie (lexicographical_compare) s1 z s2: " <<
    lexicographical_compare(s1.begin(), s1.end(),
      s2.begin(), s2.end()) << endl;
  cout << "porwnanie (lexicographical_compare) s2 z s1: " <<
    lexicographical_compare(s2.begin(), s2.end(),
      s1.begin(), s1.end()) << endl;
  cout << "porwnanie (lexicographical_compare) skrconego "
    "s1 z caym s2: " << endl;

  string s3(s1);
  while(s3.length() != 0) {
    bool result = lexicographical_compare(
      s3.begin(), s3.end(), s2.begin(),s2.end());
    cout << s3 << endl << s2 << ", result = "
      << result << endl;
    if(result == true) break;
    s3 = s3.substr(0, s3.length() - 1);
  }

  pair<string::iterator, string::iterator> p =
    mismatch(s1.begin(), s1.end(), s2.begin());
  print(p.first, s1.end(), "p.first", "");
  print(p.second, s2.end(), "p.second","");
} ///:~
